/**********************************
*        Macro Defination		  *
***********************************/
      

#define KEY1        (1 << 10)                                 // P2.10(KEY1)  
#define KEY2        (1 << 11)                                 // P2.11(KEY2)  
#define KEY3        (1 << 12)                                 // P2.12(KEY3)   
#define KEY4        (1 << 13)                                 // P2.13(KEY4)  

#define RST         (1 << 15)                                 // P0_15(RST) 
#define CD          (1 << 31)                                 // P1_31(CD) = RS 
#define RW          (1 << 25)                                 // P3_25(RW)  
#define E           (1 << 26)                                 // P3_26(E)   

#define DB0         (1 << 16)                                 // P1_16(DB0)
#define DB1         (1 << 17)                                 // P1_17(DB1)
#define DB2         (1 << 18)                                 // P1_18(DB2) 
#define DB3         (1 << 19)                                 // P1_19(DB3) 
#define DB4         (1 << 20)                                 // P1_20(DB4) 
#define DB5         (1 << 21)                                 // P1_21(DB5)
#define DB6         (1 << 22)                                 // P1_22(DB6)  
#define DB7         (1 << 23)                                 // P1_23(DB7)  
 

/**********************************
*      Function Declaration		  *
**********************************/
extern void delayUs(INT16U us);
extern void delayMs(INT16U ms);

extern void keyInit(void);

extern void lcdDdataPinsDirectionSet(INT8U direction);
extern void lcdPinInit(void);

extern void setRST(INT8U RST_value);
extern void setCD(INT8U CD_value);
extern void setRW(INT8U RW_value);
extern void setE(INT8U E_value);

extern void writeComd(INT8U comd);
extern void writeData(INT8U data);

extern void lcdInit(void);

extern void cleanScreen();
extern void printCharacter(INT8U row, INT8U column, unsigned char ch);
extern void printString(INT8U row, INT8U column, const char *str);